package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringImages {
  private Integer variantId;

  private String sku;

  private List<ImageInput> images;

  private Boolean staged = true;

  public SetProductTailoringImages() {
  }

  public SetProductTailoringImages(Integer variantId, String sku, List<ImageInput> images,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.images = images;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ImageInput> getImages() {
    return images;
  }

  public void setImages(List<ImageInput> images) {
    this.images = images;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringImages{variantId='" + variantId + "', sku='" + sku + "', images='" + images + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringImages that = (SetProductTailoringImages) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(images, that.images) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, images, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private List<ImageInput> images;

    private Boolean staged = true;

    public SetProductTailoringImages build() {
      SetProductTailoringImages result = new SetProductTailoringImages();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.images = this.images;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder images(List<ImageInput> images) {
      this.images = images;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
