package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringMetaAttributes {
  private List<LocalizedStringItemInputType> metaDescription;

  private List<LocalizedStringItemInputType> metaKeywords;

  private List<LocalizedStringItemInputType> metaTitle;

  private Boolean staged = true;

  public SetProductTailoringMetaAttributes() {
  }

  public SetProductTailoringMetaAttributes(List<LocalizedStringItemInputType> metaDescription,
      List<LocalizedStringItemInputType> metaKeywords, List<LocalizedStringItemInputType> metaTitle,
      Boolean staged) {
    this.metaDescription = metaDescription;
    this.metaKeywords = metaKeywords;
    this.metaTitle = metaTitle;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringMetaAttributes{metaDescription='" + metaDescription + "', metaKeywords='" + metaKeywords + "', metaTitle='" + metaTitle + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringMetaAttributes that = (SetProductTailoringMetaAttributes) o;
    return Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaDescription, metaKeywords, metaTitle, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaDescription;

    private List<LocalizedStringItemInputType> metaKeywords;

    private List<LocalizedStringItemInputType> metaTitle;

    private Boolean staged = true;

    public SetProductTailoringMetaAttributes build() {
      SetProductTailoringMetaAttributes result = new SetProductTailoringMetaAttributes();
      result.metaDescription = this.metaDescription;
      result.metaKeywords = this.metaKeywords;
      result.metaTitle = this.metaTitle;
      result.staged = this.staged;
      return result;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
