package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringMetaTitle {
  private List<LocalizedStringItemInputType> metaTitle;

  private Boolean staged = true;

  public SetProductTailoringMetaTitle() {
  }

  public SetProductTailoringMetaTitle(List<LocalizedStringItemInputType> metaTitle,
      Boolean staged) {
    this.metaTitle = metaTitle;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringMetaTitle{metaTitle='" + metaTitle + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringMetaTitle that = (SetProductTailoringMetaTitle) o;
    return Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaTitle, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaTitle;

    private Boolean staged = true;

    public SetProductTailoringMetaTitle build() {
      SetProductTailoringMetaTitle result = new SetProductTailoringMetaTitle();
      result.metaTitle = this.metaTitle;
      result.staged = this.staged;
      return result;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
