package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringName {
  private List<LocalizedStringItemInputType> name;

  private Boolean staged = true;

  public SetProductTailoringName() {
  }

  public SetProductTailoringName(List<LocalizedStringItemInputType> name, Boolean staged) {
    this.name = name;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringName{name='" + name + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringName that = (SetProductTailoringName) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private Boolean staged = true;

    public SetProductTailoringName build() {
      SetProductTailoringName result = new SetProductTailoringName();
      result.name = this.name;
      result.staged = this.staged;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
