package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetReviewText {
  private String text;

  public SetReviewText() {
  }

  public SetReviewText(String text) {
    this.text = text;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  @Override
  public String toString() {
    return "SetReviewText{text='" + text + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetReviewText that = (SetReviewText) o;
    return Objects.equals(text, that.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String text;

    public SetReviewText build() {
      SetReviewText result = new SetReviewText();
      result.text = this.text;
      return result;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }
  }
}
