package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetSearchKeywords {
  private List<SearchKeywordInput> searchKeywords;

  private Boolean staged;

  public SetSearchKeywords() {
  }

  public SetSearchKeywords(List<SearchKeywordInput> searchKeywords, Boolean staged) {
    this.searchKeywords = searchKeywords;
    this.staged = staged;
  }

  public List<SearchKeywordInput> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SearchKeywordInput> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetSearchKeywords{searchKeywords='" + searchKeywords + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetSearchKeywords that = (SetSearchKeywords) o;
    return Objects.equals(searchKeywords, that.searchKeywords) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchKeywords, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<SearchKeywordInput> searchKeywords;

    private Boolean staged;

    public SetSearchKeywords build() {
      SetSearchKeywords result = new SetSearchKeywords();
      result.searchKeywords = this.searchKeywords;
      result.staged = this.staged;
      return result;
    }

    public Builder searchKeywords(List<SearchKeywordInput> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
