package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetShoppingListSlug {
  private List<LocalizedStringItemInputType> slug;

  public SetShoppingListSlug() {
  }

  public SetShoppingListSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  @Override
  public String toString() {
    return "SetShoppingListSlug{slug='" + slug + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShoppingListSlug that = (SetShoppingListSlug) o;
    return Objects.equals(slug, that.slug);
  }

  @Override
  public int hashCode() {
    return Objects.hash(slug);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> slug;

    public SetShoppingListSlug build() {
      SetShoppingListSlug result = new SetShoppingListSlug();
      result.slug = this.slug;
      return result;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }
  }
}
