package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetShoppingListStore {
  private ResourceIdentifierInput store;

  public SetShoppingListStore() {
  }

  public SetShoppingListStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  public ResourceIdentifierInput getStore() {
    return store;
  }

  public void setStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  @Override
  public String toString() {
    return "SetShoppingListStore{store='" + store + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShoppingListStore that = (SetShoppingListStore) o;
    return Objects.equals(store, that.store);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput store;

    public SetShoppingListStore build() {
      SetShoppingListStore result = new SetShoppingListStore();
      result.store = this.store;
      return result;
    }

    public Builder store(ResourceIdentifierInput store) {
      this.store = store;
      return this;
    }
  }
}
