package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetShoppingListTextLineItemCustomField {
  private String textLineItemId;

  private String textLineItemKey;

  private String name;

  private String value;

  public SetShoppingListTextLineItemCustomField() {
  }

  public SetShoppingListTextLineItemCustomField(String textLineItemId, String textLineItemKey,
      String name, String value) {
    this.textLineItemId = textLineItemId;
    this.textLineItemKey = textLineItemKey;
    this.name = name;
    this.value = value;
  }

  public String getTextLineItemId() {
    return textLineItemId;
  }

  public void setTextLineItemId(String textLineItemId) {
    this.textLineItemId = textLineItemId;
  }

  public String getTextLineItemKey() {
    return textLineItemKey;
  }

  public void setTextLineItemKey(String textLineItemKey) {
    this.textLineItemKey = textLineItemKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetShoppingListTextLineItemCustomField{textLineItemId='" + textLineItemId + "', textLineItemKey='" + textLineItemKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShoppingListTextLineItemCustomField that = (SetShoppingListTextLineItemCustomField) o;
    return Objects.equals(textLineItemId, that.textLineItemId) &&
        Objects.equals(textLineItemKey, that.textLineItemKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(textLineItemId, textLineItemKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String textLineItemId;

    private String textLineItemKey;

    private String name;

    private String value;

    public SetShoppingListTextLineItemCustomField build() {
      SetShoppingListTextLineItemCustomField result = new SetShoppingListTextLineItemCustomField();
      result.textLineItemId = this.textLineItemId;
      result.textLineItemKey = this.textLineItemKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder textLineItemId(String textLineItemId) {
      this.textLineItemId = textLineItemId;
      return this;
    }

    public Builder textLineItemKey(String textLineItemKey) {
      this.textLineItemKey = textLineItemKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
