package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetShoppingListTextLineItemDescription {
  private String textLineItemId;

  private String textLineItemKey;

  private List<LocalizedStringItemInputType> description;

  public SetShoppingListTextLineItemDescription() {
  }

  public SetShoppingListTextLineItemDescription(String textLineItemId, String textLineItemKey,
      List<LocalizedStringItemInputType> description) {
    this.textLineItemId = textLineItemId;
    this.textLineItemKey = textLineItemKey;
    this.description = description;
  }

  public String getTextLineItemId() {
    return textLineItemId;
  }

  public void setTextLineItemId(String textLineItemId) {
    this.textLineItemId = textLineItemId;
  }

  public String getTextLineItemKey() {
    return textLineItemKey;
  }

  public void setTextLineItemKey(String textLineItemKey) {
    this.textLineItemKey = textLineItemKey;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return "SetShoppingListTextLineItemDescription{textLineItemId='" + textLineItemId + "', textLineItemKey='" + textLineItemKey + "', description='" + description + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShoppingListTextLineItemDescription that = (SetShoppingListTextLineItemDescription) o;
    return Objects.equals(textLineItemId, that.textLineItemId) &&
        Objects.equals(textLineItemKey, that.textLineItemKey) &&
        Objects.equals(description, that.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(textLineItemId, textLineItemKey, description);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String textLineItemId;

    private String textLineItemKey;

    private List<LocalizedStringItemInputType> description;

    public SetShoppingListTextLineItemDescription build() {
      SetShoppingListTextLineItemDescription result = new SetShoppingListTextLineItemDescription();
      result.textLineItemId = this.textLineItemId;
      result.textLineItemKey = this.textLineItemKey;
      result.description = this.description;
      return result;
    }

    public Builder textLineItemId(String textLineItemId) {
      this.textLineItemId = textLineItemId;
      return this;
    }

    public Builder textLineItemKey(String textLineItemKey) {
      this.textLineItemKey = textLineItemKey;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }
  }
}
