package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderBusinessUnit {
  private ResourceIdentifierInput businessUnit;

  public SetStagedOrderBusinessUnit() {
  }

  public SetStagedOrderBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  @Override
  public String toString() {
    return "SetStagedOrderBusinessUnit{businessUnit='" + businessUnit + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderBusinessUnit that = (SetStagedOrderBusinessUnit) o;
    return Objects.equals(businessUnit, that.businessUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnit);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput businessUnit;

    public SetStagedOrderBusinessUnit build() {
      SetStagedOrderBusinessUnit result = new SetStagedOrderBusinessUnit();
      result.businessUnit = this.businessUnit;
      return result;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }
  }
}
