package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomLineItemCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  private String name;

  private JsonNode value;

  public SetStagedOrderCustomLineItemCustomFieldOutput() {
  }

  public SetStagedOrderCustomLineItemCustomFieldOutput(String type, String customLineItemId,
      String customLineItemKey, String name, JsonNode value) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.name = name;
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomLineItemCustomFieldOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomLineItemCustomFieldOutput that = (SetStagedOrderCustomLineItemCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    private String name;

    private JsonNode value;

    public SetStagedOrderCustomLineItemCustomFieldOutput build() {
      SetStagedOrderCustomLineItemCustomFieldOutput result = new SetStagedOrderCustomLineItemCustomFieldOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }
  }
}
