package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomShippingMethodOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String shippingMethodName;

  private ShippingRate shippingRate;

  private ResourceIdentifier taxCategoryResId;

  private ExternalTaxRateDraftOutput externalTaxRate;

  private CustomFieldsCommand custom;

  public SetStagedOrderCustomShippingMethodOutput() {
  }

  public SetStagedOrderCustomShippingMethodOutput(String type, String shippingMethodName,
      ShippingRate shippingRate, ResourceIdentifier taxCategoryResId,
      ExternalTaxRateDraftOutput externalTaxRate, CustomFieldsCommand custom) {
    this.type = type;
    this.shippingMethodName = shippingMethodName;
    this.shippingRate = shippingRate;
    this.taxCategoryResId = taxCategoryResId;
    this.externalTaxRate = externalTaxRate;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public ShippingRate getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRate shippingRate) {
    this.shippingRate = shippingRate;
  }

  public ResourceIdentifier getTaxCategoryResId() {
    return taxCategoryResId;
  }

  public void setTaxCategoryResId(ResourceIdentifier taxCategoryResId) {
    this.taxCategoryResId = taxCategoryResId;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomShippingMethodOutput{type='" + type + "', shippingMethodName='" + shippingMethodName + "', shippingRate='" + shippingRate + "', taxCategoryResId='" + taxCategoryResId + "', externalTaxRate='" + externalTaxRate + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomShippingMethodOutput that = (SetStagedOrderCustomShippingMethodOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(taxCategoryResId, that.taxCategoryResId) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shippingMethodName, shippingRate, taxCategoryResId, externalTaxRate, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String shippingMethodName;

    private ShippingRate shippingRate;

    private ResourceIdentifier taxCategoryResId;

    private ExternalTaxRateDraftOutput externalTaxRate;

    private CustomFieldsCommand custom;

    public SetStagedOrderCustomShippingMethodOutput build() {
      SetStagedOrderCustomShippingMethodOutput result = new SetStagedOrderCustomShippingMethodOutput();
      result.type = this.type;
      result.shippingMethodName = this.shippingMethodName;
      result.shippingRate = this.shippingRate;
      result.taxCategoryResId = this.taxCategoryResId;
      result.externalTaxRate = this.externalTaxRate;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder shippingRate(ShippingRate shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder taxCategoryResId(ResourceIdentifier taxCategoryResId) {
      this.taxCategoryResId = taxCategoryResId;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
