package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomerEmailOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String email;

  public SetStagedOrderCustomerEmailOutput() {
  }

  public SetStagedOrderCustomerEmailOutput(String type, String email) {
    this.type = type;
    this.email = email;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomerEmailOutput{type='" + type + "', email='" + email + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomerEmailOutput that = (SetStagedOrderCustomerEmailOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(email, that.email);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, email);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String email;

    public SetStagedOrderCustomerEmailOutput build() {
      SetStagedOrderCustomerEmailOutput result = new SetStagedOrderCustomerEmailOutput();
      result.type = this.type;
      result.email = this.email;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }
  }
}
