package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomerGroupOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private CustomerGroupReferenceIdentifier customerGroupResId;

  public SetStagedOrderCustomerGroupOutput() {
  }

  public SetStagedOrderCustomerGroupOutput(String type,
      CustomerGroupReferenceIdentifier customerGroupResId) {
    this.type = type;
    this.customerGroupResId = customerGroupResId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomerGroupReferenceIdentifier getCustomerGroupResId() {
    return customerGroupResId;
  }

  public void setCustomerGroupResId(CustomerGroupReferenceIdentifier customerGroupResId) {
    this.customerGroupResId = customerGroupResId;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomerGroupOutput{type='" + type + "', customerGroupResId='" + customerGroupResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomerGroupOutput that = (SetStagedOrderCustomerGroupOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customerGroupResId, that.customerGroupResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customerGroupResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private CustomerGroupReferenceIdentifier customerGroupResId;

    public SetStagedOrderCustomerGroupOutput build() {
      SetStagedOrderCustomerGroupOutput result = new SetStagedOrderCustomerGroupOutput();
      result.type = this.type;
      result.customerGroupResId = this.customerGroupResId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customerGroupResId(CustomerGroupReferenceIdentifier customerGroupResId) {
      this.customerGroupResId = customerGroupResId;
      return this;
    }
  }
}
