package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderDeliveryAddressCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryId;

  private String deliveryKey;

  private String name;

  private JsonNode value;

  public SetStagedOrderDeliveryAddressCustomFieldOutput() {
  }

  public SetStagedOrderDeliveryAddressCustomFieldOutput(String type, String deliveryId,
      String deliveryKey, String name, JsonNode value) {
    this.type = type;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.name = name;
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDeliveryAddressCustomFieldOutput{type='" + type + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDeliveryAddressCustomFieldOutput that = (SetStagedOrderDeliveryAddressCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryId, deliveryKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryId;

    private String deliveryKey;

    private String name;

    private JsonNode value;

    public SetStagedOrderDeliveryAddressCustomFieldOutput build() {
      SetStagedOrderDeliveryAddressCustomFieldOutput result = new SetStagedOrderDeliveryAddressCustomFieldOutput();
      result.type = this.type;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }
  }
}
