package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderDeliveryAddressCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryId;

  private String deliveryKey;

  private CustomFieldsCommand custom;

  public SetStagedOrderDeliveryAddressCustomTypeOutput() {
  }

  public SetStagedOrderDeliveryAddressCustomTypeOutput(String type, String deliveryId,
      String deliveryKey, CustomFieldsCommand custom) {
    this.type = type;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDeliveryAddressCustomTypeOutput{type='" + type + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDeliveryAddressCustomTypeOutput that = (SetStagedOrderDeliveryAddressCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryId, deliveryKey, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryId;

    private String deliveryKey;

    private CustomFieldsCommand custom;

    public SetStagedOrderDeliveryAddressCustomTypeOutput build() {
      SetStagedOrderDeliveryAddressCustomTypeOutput result = new SetStagedOrderDeliveryAddressCustomTypeOutput();
      result.type = this.type;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
