package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderDeliveryCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String name;

  private JsonNode value;

  private String deliveryId;

  private String deliveryKey;

  public SetStagedOrderDeliveryCustomFieldOutput() {
  }

  public SetStagedOrderDeliveryCustomFieldOutput(String type, String name, JsonNode value,
      String deliveryId, String deliveryKey) {
    this.type = type;
    this.name = name;
    this.value = value;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDeliveryCustomFieldOutput{type='" + type + "', name='" + name + "', value='" + value + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDeliveryCustomFieldOutput that = (SetStagedOrderDeliveryCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, value, deliveryId, deliveryKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String name;

    private JsonNode value;

    private String deliveryId;

    private String deliveryKey;

    public SetStagedOrderDeliveryCustomFieldOutput build() {
      SetStagedOrderDeliveryCustomFieldOutput result = new SetStagedOrderDeliveryCustomFieldOutput();
      result.type = this.type;
      result.name = this.name;
      result.value = this.value;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }
  }
}
