package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderDeliveryItemsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryId;

  private String deliveryKey;

  private List<DeliveryItem> items;

  public SetStagedOrderDeliveryItemsOutput() {
  }

  public SetStagedOrderDeliveryItemsOutput(String type, String deliveryId, String deliveryKey,
      List<DeliveryItem> items) {
    this.type = type;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.items = items;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDeliveryItemsOutput{type='" + type + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', items='" + items + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDeliveryItemsOutput that = (SetStagedOrderDeliveryItemsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(items, that.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryId, deliveryKey, items);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryId;

    private String deliveryKey;

    private List<DeliveryItem> items;

    public SetStagedOrderDeliveryItemsOutput build() {
      SetStagedOrderDeliveryItemsOutput result = new SetStagedOrderDeliveryItemsOutput();
      result.type = this.type;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.items = this.items;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }
  }
}
