package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderDirectDiscountsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private List<DirectDiscountDraftOutput> discounts;

  public SetStagedOrderDirectDiscountsOutput() {
  }

  public SetStagedOrderDirectDiscountsOutput(String type,
      List<DirectDiscountDraftOutput> discounts) {
    this.type = type;
    this.discounts = discounts;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<DirectDiscountDraftOutput> getDiscounts() {
    return discounts;
  }

  public void setDiscounts(List<DirectDiscountDraftOutput> discounts) {
    this.discounts = discounts;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDirectDiscountsOutput{type='" + type + "', discounts='" + discounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDirectDiscountsOutput that = (SetStagedOrderDirectDiscountsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(discounts, that.discounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, discounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<DirectDiscountDraftOutput> discounts;

    public SetStagedOrderDirectDiscountsOutput build() {
      SetStagedOrderDirectDiscountsOutput result = new SetStagedOrderDirectDiscountsOutput();
      result.type = this.type;
      result.discounts = this.discounts;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder discounts(List<DirectDiscountDraftOutput> discounts) {
      this.discounts = discounts;
      return this;
    }
  }
}
