package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemDistributionChannelOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private ChannelReferenceIdentifier distributionChannelResId;

  private String lineItemKey;

  public SetStagedOrderLineItemDistributionChannelOutput() {
  }

  public SetStagedOrderLineItemDistributionChannelOutput(String type, String lineItemId,
      ChannelReferenceIdentifier distributionChannelResId, String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.distributionChannelResId = distributionChannelResId;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ChannelReferenceIdentifier getDistributionChannelResId() {
    return distributionChannelResId;
  }

  public void setDistributionChannelResId(ChannelReferenceIdentifier distributionChannelResId) {
    this.distributionChannelResId = distributionChannelResId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemDistributionChannelOutput{type='" + type + "', lineItemId='" + lineItemId + "', distributionChannelResId='" + distributionChannelResId + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemDistributionChannelOutput that = (SetStagedOrderLineItemDistributionChannelOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(distributionChannelResId, that.distributionChannelResId) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, distributionChannelResId, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private ChannelReferenceIdentifier distributionChannelResId;

    private String lineItemKey;

    public SetStagedOrderLineItemDistributionChannelOutput build() {
      SetStagedOrderLineItemDistributionChannelOutput result = new SetStagedOrderLineItemDistributionChannelOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.distributionChannelResId = this.distributionChannelResId;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder distributionChannelResId(ChannelReferenceIdentifier distributionChannelResId) {
      this.distributionChannelResId = distributionChannelResId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
