package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemPriceOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private BaseMoney externalPrice;

  private String lineItemKey;

  public SetStagedOrderLineItemPriceOutput() {
  }

  public SetStagedOrderLineItemPriceOutput(String type, String lineItemId, BaseMoney externalPrice,
      String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.externalPrice = externalPrice;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public BaseMoney getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoney externalPrice) {
    this.externalPrice = externalPrice;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemPriceOutput{type='" + type + "', lineItemId='" + lineItemId + "', externalPrice='" + externalPrice + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemPriceOutput that = (SetStagedOrderLineItemPriceOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, externalPrice, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private BaseMoney externalPrice;

    private String lineItemKey;

    public SetStagedOrderLineItemPriceOutput build() {
      SetStagedOrderLineItemPriceOutput result = new SetStagedOrderLineItemPriceOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.externalPrice = this.externalPrice;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalPrice(BaseMoney externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
