package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemShippingDetailsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private ItemShippingDetailsDraftOutput shippingDetails;

  private String lineItemKey;

  public SetStagedOrderLineItemShippingDetailsOutput() {
  }

  public SetStagedOrderLineItemShippingDetailsOutput(String type, String lineItemId,
      ItemShippingDetailsDraftOutput shippingDetails, String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.shippingDetails = shippingDetails;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ItemShippingDetailsDraftOutput getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemShippingDetailsOutput{type='" + type + "', lineItemId='" + lineItemId + "', shippingDetails='" + shippingDetails + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemShippingDetailsOutput that = (SetStagedOrderLineItemShippingDetailsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, shippingDetails, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private ItemShippingDetailsDraftOutput shippingDetails;

    private String lineItemKey;

    public SetStagedOrderLineItemShippingDetailsOutput build() {
      SetStagedOrderLineItemShippingDetailsOutput result = new SetStagedOrderLineItemShippingDetailsOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.shippingDetails = this.shippingDetails;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
