package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemTaxAmountOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private ExternalTaxAmountDraftOutput externalTaxAmount;

  private String shippingKey;

  private String lineItemKey;

  public SetStagedOrderLineItemTaxAmountOutput() {
  }

  public SetStagedOrderLineItemTaxAmountOutput(String type, String lineItemId,
      ExternalTaxAmountDraftOutput externalTaxAmount, String shippingKey, String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.externalTaxAmount = externalTaxAmount;
    this.shippingKey = shippingKey;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ExternalTaxAmountDraftOutput getExternalTaxAmount() {
    return externalTaxAmount;
  }

  public void setExternalTaxAmount(ExternalTaxAmountDraftOutput externalTaxAmount) {
    this.externalTaxAmount = externalTaxAmount;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemTaxAmountOutput{type='" + type + "', lineItemId='" + lineItemId + "', externalTaxAmount='" + externalTaxAmount + "', shippingKey='" + shippingKey + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemTaxAmountOutput that = (SetStagedOrderLineItemTaxAmountOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalTaxAmount, that.externalTaxAmount) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, externalTaxAmount, shippingKey, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private ExternalTaxAmountDraftOutput externalTaxAmount;

    private String shippingKey;

    private String lineItemKey;

    public SetStagedOrderLineItemTaxAmountOutput build() {
      SetStagedOrderLineItemTaxAmountOutput result = new SetStagedOrderLineItemTaxAmountOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.externalTaxAmount = this.externalTaxAmount;
      result.shippingKey = this.shippingKey;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalTaxAmount(ExternalTaxAmountDraftOutput externalTaxAmount) {
      this.externalTaxAmount = externalTaxAmount;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
