package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderLineItemTotalPrice {
  private String lineItemId;

  private ExternalLineItemTotalPriceDraft externalTotalPrice;

  private String lineItemKey;

  public SetStagedOrderLineItemTotalPrice() {
  }

  public SetStagedOrderLineItemTotalPrice(String lineItemId,
      ExternalLineItemTotalPriceDraft externalTotalPrice, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.externalTotalPrice = externalTotalPrice;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ExternalLineItemTotalPriceDraft getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemTotalPrice{lineItemId='" + lineItemId + "', externalTotalPrice='" + externalTotalPrice + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemTotalPrice that = (SetStagedOrderLineItemTotalPrice) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, externalTotalPrice, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ExternalLineItemTotalPriceDraft externalTotalPrice;

    private String lineItemKey;

    public SetStagedOrderLineItemTotalPrice build() {
      SetStagedOrderLineItemTotalPrice result = new SetStagedOrderLineItemTotalPrice();
      result.lineItemId = this.lineItemId;
      result.externalTotalPrice = this.externalTotalPrice;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
