package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLocaleOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String locale;

  public SetStagedOrderLocaleOutput() {
  }

  public SetStagedOrderLocaleOutput(String type, String locale) {
    this.type = type;
    this.locale = locale;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLocaleOutput{type='" + type + "', locale='" + locale + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLocaleOutput that = (SetStagedOrderLocaleOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(locale, that.locale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, locale);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String locale;

    public SetStagedOrderLocaleOutput build() {
      SetStagedOrderLocaleOutput result = new SetStagedOrderLocaleOutput();
      result.type = this.type;
      result.locale = this.locale;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }
  }
}
