package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderOrderNumber {
  private String orderNumber;

  public SetStagedOrderOrderNumber() {
  }

  public SetStagedOrderOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  @Override
  public String toString() {
    return "SetStagedOrderOrderNumber{orderNumber='" + orderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderOrderNumber that = (SetStagedOrderOrderNumber) o;
    return Objects.equals(orderNumber, that.orderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String orderNumber;

    public SetStagedOrderOrderNumber build() {
      SetStagedOrderOrderNumber result = new SetStagedOrderOrderNumber();
      result.orderNumber = this.orderNumber;
      return result;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }
  }
}
