package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderOrderNumberOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String orderNumber;

  public SetStagedOrderOrderNumberOutput() {
  }

  public SetStagedOrderOrderNumberOutput(String type, String orderNumber) {
    this.type = type;
    this.orderNumber = orderNumber;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  @Override
  public String toString() {
    return "SetStagedOrderOrderNumberOutput{type='" + type + "', orderNumber='" + orderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderOrderNumberOutput that = (SetStagedOrderOrderNumberOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(orderNumber, that.orderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, orderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String orderNumber;

    public SetStagedOrderOrderNumberOutput build() {
      SetStagedOrderOrderNumberOutput result = new SetStagedOrderOrderNumberOutput();
      result.type = this.type;
      result.orderNumber = this.orderNumber;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }
  }
}
