package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderOrderTotalTaxOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private Money externalTotalGross;

  private List<TaxPortion> externalTaxPortions;

  public SetStagedOrderOrderTotalTaxOutput() {
  }

  public SetStagedOrderOrderTotalTaxOutput(String type, Money externalTotalGross,
      List<TaxPortion> externalTaxPortions) {
    this.type = type;
    this.externalTotalGross = externalTotalGross;
    this.externalTaxPortions = externalTaxPortions;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Money getExternalTotalGross() {
    return externalTotalGross;
  }

  public void setExternalTotalGross(Money externalTotalGross) {
    this.externalTotalGross = externalTotalGross;
  }

  public List<TaxPortion> getExternalTaxPortions() {
    return externalTaxPortions;
  }

  public void setExternalTaxPortions(List<TaxPortion> externalTaxPortions) {
    this.externalTaxPortions = externalTaxPortions;
  }

  @Override
  public String toString() {
    return "SetStagedOrderOrderTotalTaxOutput{type='" + type + "', externalTotalGross='" + externalTotalGross + "', externalTaxPortions='" + externalTaxPortions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderOrderTotalTaxOutput that = (SetStagedOrderOrderTotalTaxOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(externalTotalGross, that.externalTotalGross) &&
        Objects.equals(externalTaxPortions, that.externalTaxPortions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, externalTotalGross, externalTaxPortions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private Money externalTotalGross;

    private List<TaxPortion> externalTaxPortions;

    public SetStagedOrderOrderTotalTaxOutput build() {
      SetStagedOrderOrderTotalTaxOutput result = new SetStagedOrderOrderTotalTaxOutput();
      result.type = this.type;
      result.externalTotalGross = this.externalTotalGross;
      result.externalTaxPortions = this.externalTaxPortions;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder externalTotalGross(Money externalTotalGross) {
      this.externalTotalGross = externalTotalGross;
      return this;
    }

    public Builder externalTaxPortions(List<TaxPortion> externalTaxPortions) {
      this.externalTaxPortions = externalTaxPortions;
      return this;
    }
  }
}
