package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStagedOrderParcelCustomType {
  private List<CustomFieldInput> fields;

  private ResourceIdentifierInput type;

  private String typeKey;

  private String typeId;

  private String parcelId;

  private String parcelKey;

  public SetStagedOrderParcelCustomType() {
  }

  public SetStagedOrderParcelCustomType(List<CustomFieldInput> fields, ResourceIdentifierInput type,
      String typeKey, String typeId, String parcelId, String parcelKey) {
    this.fields = fields;
    this.type = type;
    this.typeKey = typeKey;
    this.typeId = typeId;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelCustomType{fields='" + fields + "', type='" + type + "', typeKey='" + typeKey + "', typeId='" + typeId + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelCustomType that = (SetStagedOrderParcelCustomType) o;
    return Objects.equals(fields, that.fields) &&
        Objects.equals(type, that.type) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(typeId, that.typeId) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fields, type, typeKey, typeId, parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CustomFieldInput> fields;

    private ResourceIdentifierInput type;

    private String typeKey;

    private String typeId;

    private String parcelId;

    private String parcelKey;

    public SetStagedOrderParcelCustomType build() {
      SetStagedOrderParcelCustomType result = new SetStagedOrderParcelCustomType();
      result.fields = this.fields;
      result.type = this.type;
      result.typeKey = this.typeKey;
      result.typeId = this.typeId;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
