package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderParcelCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private CustomFieldsCommand custom;

  private String parcelId;

  private String parcelKey;

  public SetStagedOrderParcelCustomTypeOutput() {
  }

  public SetStagedOrderParcelCustomTypeOutput(String type, CustomFieldsCommand custom,
      String parcelId, String parcelKey) {
    this.type = type;
    this.custom = custom;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelCustomTypeOutput{type='" + type + "', custom='" + custom + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelCustomTypeOutput that = (SetStagedOrderParcelCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, custom, parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private CustomFieldsCommand custom;

    private String parcelId;

    private String parcelKey;

    public SetStagedOrderParcelCustomTypeOutput build() {
      SetStagedOrderParcelCustomTypeOutput result = new SetStagedOrderParcelCustomTypeOutput();
      result.type = this.type;
      result.custom = this.custom;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
