package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderParcelItemsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String parcelId;

  private String parcelKey;

  private List<DeliveryItem> items;

  public SetStagedOrderParcelItemsOutput() {
  }

  public SetStagedOrderParcelItemsOutput(String type, String parcelId, String parcelKey,
      List<DeliveryItem> items) {
    this.type = type;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
    this.items = items;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelItemsOutput{type='" + type + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "', items='" + items + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelItemsOutput that = (SetStagedOrderParcelItemsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(items, that.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, parcelId, parcelKey, items);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String parcelId;

    private String parcelKey;

    private List<DeliveryItem> items;

    public SetStagedOrderParcelItemsOutput build() {
      SetStagedOrderParcelItemsOutput result = new SetStagedOrderParcelItemsOutput();
      result.type = this.type;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      result.items = this.items;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }
  }
}
