package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderParcelMeasurements {
  private String parcelId;

  private String parcelKey;

  private ParcelMeasurementsDraftType measurements;

  public SetStagedOrderParcelMeasurements() {
  }

  public SetStagedOrderParcelMeasurements(String parcelId, String parcelKey,
      ParcelMeasurementsDraftType measurements) {
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
    this.measurements = measurements;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public ParcelMeasurementsDraftType getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurementsDraftType measurements) {
    this.measurements = measurements;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelMeasurements{parcelId='" + parcelId + "', parcelKey='" + parcelKey + "', measurements='" + measurements + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelMeasurements that = (SetStagedOrderParcelMeasurements) o;
    return Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(measurements, that.measurements);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parcelId, parcelKey, measurements);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String parcelId;

    private String parcelKey;

    private ParcelMeasurementsDraftType measurements;

    public SetStagedOrderParcelMeasurements build() {
      SetStagedOrderParcelMeasurements result = new SetStagedOrderParcelMeasurements();
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      result.measurements = this.measurements;
      return result;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder measurements(ParcelMeasurementsDraftType measurements) {
      this.measurements = measurements;
      return this;
    }
  }
}
