package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderParcelTrackingDataOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String parcelId;

  private String parcelKey;

  private TrackingData trackingData;

  public SetStagedOrderParcelTrackingDataOutput() {
  }

  public SetStagedOrderParcelTrackingDataOutput(String type, String parcelId, String parcelKey,
      TrackingData trackingData) {
    this.type = type;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
    this.trackingData = trackingData;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public TrackingData getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingData trackingData) {
    this.trackingData = trackingData;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelTrackingDataOutput{type='" + type + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "', trackingData='" + trackingData + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelTrackingDataOutput that = (SetStagedOrderParcelTrackingDataOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(trackingData, that.trackingData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, parcelId, parcelKey, trackingData);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String parcelId;

    private String parcelKey;

    private TrackingData trackingData;

    public SetStagedOrderParcelTrackingDataOutput build() {
      SetStagedOrderParcelTrackingDataOutput result = new SetStagedOrderParcelTrackingDataOutput();
      result.type = this.type;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      result.trackingData = this.trackingData;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder trackingData(TrackingData trackingData) {
      this.trackingData = trackingData;
      return this;
    }
  }
}
