package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetStagedOrderReturnInfo {
  private List<ReturnInfoDraftType> items = Collections.emptyList();

  public SetStagedOrderReturnInfo() {
  }

  public SetStagedOrderReturnInfo(List<ReturnInfoDraftType> items) {
    this.items = items;
  }

  public List<ReturnInfoDraftType> getItems() {
    return items;
  }

  public void setItems(List<ReturnInfoDraftType> items) {
    this.items = items;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnInfo{items='" + items + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnInfo that = (SetStagedOrderReturnInfo) o;
    return Objects.equals(items, that.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ReturnInfoDraftType> items = Collections.emptyList();

    public SetStagedOrderReturnInfo build() {
      SetStagedOrderReturnInfo result = new SetStagedOrderReturnInfo();
      result.items = this.items;
      return result;
    }

    public Builder items(List<ReturnInfoDraftType> items) {
      this.items = items;
      return this;
    }
  }
}
