package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderReturnInfoOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private List<ReturnInfoDraftTypeOutput> items;

  public SetStagedOrderReturnInfoOutput() {
  }

  public SetStagedOrderReturnInfoOutput(String type, List<ReturnInfoDraftTypeOutput> items) {
    this.type = type;
    this.items = items;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<ReturnInfoDraftTypeOutput> getItems() {
    return items;
  }

  public void setItems(List<ReturnInfoDraftTypeOutput> items) {
    this.items = items;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnInfoOutput{type='" + type + "', items='" + items + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnInfoOutput that = (SetStagedOrderReturnInfoOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(items, that.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, items);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<ReturnInfoDraftTypeOutput> items;

    public SetStagedOrderReturnInfoOutput build() {
      SetStagedOrderReturnInfoOutput result = new SetStagedOrderReturnInfoOutput();
      result.type = this.type;
      result.items = this.items;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder items(List<ReturnInfoDraftTypeOutput> items) {
      this.items = items;
      return this;
    }
  }
}
