package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderReturnItemCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String name;

  private JsonNode value;

  private String returnItemId;

  private String returnItemKey;

  public SetStagedOrderReturnItemCustomFieldOutput() {
  }

  public SetStagedOrderReturnItemCustomFieldOutput(String type, String name, JsonNode value,
      String returnItemId, String returnItemKey) {
    this.type = type;
    this.name = name;
    this.value = value;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnItemCustomFieldOutput{type='" + type + "', name='" + name + "', value='" + value + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnItemCustomFieldOutput that = (SetStagedOrderReturnItemCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, value, returnItemId, returnItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String name;

    private JsonNode value;

    private String returnItemId;

    private String returnItemKey;

    public SetStagedOrderReturnItemCustomFieldOutput build() {
      SetStagedOrderReturnItemCustomFieldOutput result = new SetStagedOrderReturnItemCustomFieldOutput();
      result.type = this.type;
      result.name = this.name;
      result.value = this.value;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }
  }
}
