package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderReturnPaymentState {
  private String returnItemId;

  private String returnItemKey;

  private ReturnPaymentState paymentState;

  public SetStagedOrderReturnPaymentState() {
  }

  public SetStagedOrderReturnPaymentState(String returnItemId, String returnItemKey,
      ReturnPaymentState paymentState) {
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
    this.paymentState = paymentState;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  public ReturnPaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(ReturnPaymentState paymentState) {
    this.paymentState = paymentState;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnPaymentState{returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "', paymentState='" + paymentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnPaymentState that = (SetStagedOrderReturnPaymentState) o;
    return Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey) &&
        Objects.equals(paymentState, that.paymentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(returnItemId, returnItemKey, paymentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String returnItemId;

    private String returnItemKey;

    private ReturnPaymentState paymentState;

    public SetStagedOrderReturnPaymentState build() {
      SetStagedOrderReturnPaymentState result = new SetStagedOrderReturnPaymentState();
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      result.paymentState = this.paymentState;
      return result;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }

    public Builder paymentState(ReturnPaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }
  }
}
