package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderShippingAddressAndCustomShippingMethod {
  private AddressInput address;

  private String shippingMethodName;

  private ShippingRateDraft shippingRate;

  private ResourceIdentifierInput taxCategory;

  private ExternalTaxRateDraft externalTaxRate;

  private CustomFieldsDraft custom;

  public SetStagedOrderShippingAddressAndCustomShippingMethod() {
  }

  public SetStagedOrderShippingAddressAndCustomShippingMethod(AddressInput address,
      String shippingMethodName, ShippingRateDraft shippingRate,
      ResourceIdentifierInput taxCategory, ExternalTaxRateDraft externalTaxRate,
      CustomFieldsDraft custom) {
    this.address = address;
    this.shippingMethodName = shippingMethodName;
    this.shippingRate = shippingRate;
    this.taxCategory = taxCategory;
    this.externalTaxRate = externalTaxRate;
    this.custom = custom;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public ShippingRateDraft getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRateDraft shippingRate) {
    this.shippingRate = shippingRate;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingAddressAndCustomShippingMethod{address='" + address + "', shippingMethodName='" + shippingMethodName + "', shippingRate='" + shippingRate + "', taxCategory='" + taxCategory + "', externalTaxRate='" + externalTaxRate + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingAddressAndCustomShippingMethod that = (SetStagedOrderShippingAddressAndCustomShippingMethod) o;
    return Objects.equals(address, that.address) &&
        Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, shippingMethodName, shippingRate, taxCategory, externalTaxRate, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddressInput address;

    private String shippingMethodName;

    private ShippingRateDraft shippingRate;

    private ResourceIdentifierInput taxCategory;

    private ExternalTaxRateDraft externalTaxRate;

    private CustomFieldsDraft custom;

    public SetStagedOrderShippingAddressAndCustomShippingMethod build() {
      SetStagedOrderShippingAddressAndCustomShippingMethod result = new SetStagedOrderShippingAddressAndCustomShippingMethod();
      result.address = this.address;
      result.shippingMethodName = this.shippingMethodName;
      result.shippingRate = this.shippingRate;
      result.taxCategory = this.taxCategory;
      result.externalTaxRate = this.externalTaxRate;
      result.custom = this.custom;
      return result;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder shippingRate(ShippingRateDraft shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
