package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderShippingAddressAndShippingMethod {
  private AddressInput address;

  private ResourceIdentifierInput shippingMethod;

  private ExternalTaxRateDraft externalTaxRate;

  public SetStagedOrderShippingAddressAndShippingMethod() {
  }

  public SetStagedOrderShippingAddressAndShippingMethod(AddressInput address,
      ResourceIdentifierInput shippingMethod, ExternalTaxRateDraft externalTaxRate) {
    this.address = address;
    this.shippingMethod = shippingMethod;
    this.externalTaxRate = externalTaxRate;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingAddressAndShippingMethod{address='" + address + "', shippingMethod='" + shippingMethod + "', externalTaxRate='" + externalTaxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingAddressAndShippingMethod that = (SetStagedOrderShippingAddressAndShippingMethod) o;
    return Objects.equals(address, that.address) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(externalTaxRate, that.externalTaxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, shippingMethod, externalTaxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddressInput address;

    private ResourceIdentifierInput shippingMethod;

    private ExternalTaxRateDraft externalTaxRate;

    public SetStagedOrderShippingAddressAndShippingMethod build() {
      SetStagedOrderShippingAddressAndShippingMethod result = new SetStagedOrderShippingAddressAndShippingMethod();
      result.address = this.address;
      result.shippingMethod = this.shippingMethod;
      result.externalTaxRate = this.externalTaxRate;
      return result;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }
  }
}
