package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingAddressAndShippingMethodOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private AddressDraft address;

  private ResourceIdentifier shippingMethodResId;

  private ExternalTaxRateDraftOutput externalTaxRate;

  public SetStagedOrderShippingAddressAndShippingMethodOutput() {
  }

  public SetStagedOrderShippingAddressAndShippingMethodOutput(String type, AddressDraft address,
      ResourceIdentifier shippingMethodResId, ExternalTaxRateDraftOutput externalTaxRate) {
    this.type = type;
    this.address = address;
    this.shippingMethodResId = shippingMethodResId;
    this.externalTaxRate = externalTaxRate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public AddressDraft getAddress() {
    return address;
  }

  public void setAddress(AddressDraft address) {
    this.address = address;
  }

  public ResourceIdentifier getShippingMethodResId() {
    return shippingMethodResId;
  }

  public void setShippingMethodResId(ResourceIdentifier shippingMethodResId) {
    this.shippingMethodResId = shippingMethodResId;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingAddressAndShippingMethodOutput{type='" + type + "', address='" + address + "', shippingMethodResId='" + shippingMethodResId + "', externalTaxRate='" + externalTaxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingAddressAndShippingMethodOutput that = (SetStagedOrderShippingAddressAndShippingMethodOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(address, that.address) &&
        Objects.equals(shippingMethodResId, that.shippingMethodResId) &&
        Objects.equals(externalTaxRate, that.externalTaxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, address, shippingMethodResId, externalTaxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private AddressDraft address;

    private ResourceIdentifier shippingMethodResId;

    private ExternalTaxRateDraftOutput externalTaxRate;

    public SetStagedOrderShippingAddressAndShippingMethodOutput build() {
      SetStagedOrderShippingAddressAndShippingMethodOutput result = new SetStagedOrderShippingAddressAndShippingMethodOutput();
      result.type = this.type;
      result.address = this.address;
      result.shippingMethodResId = this.shippingMethodResId;
      result.externalTaxRate = this.externalTaxRate;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder address(AddressDraft address) {
      this.address = address;
      return this;
    }

    public Builder shippingMethodResId(ResourceIdentifier shippingMethodResId) {
      this.shippingMethodResId = shippingMethodResId;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }
  }
}
