package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingAddressCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String name;

  private JsonNode value;

  public SetStagedOrderShippingAddressCustomFieldOutput() {
  }

  public SetStagedOrderShippingAddressCustomFieldOutput(String type, String name, JsonNode value) {
    this.type = type;
    this.name = name;
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingAddressCustomFieldOutput{type='" + type + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingAddressCustomFieldOutput that = (SetStagedOrderShippingAddressCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String name;

    private JsonNode value;

    public SetStagedOrderShippingAddressCustomFieldOutput build() {
      SetStagedOrderShippingAddressCustomFieldOutput result = new SetStagedOrderShippingAddressCustomFieldOutput();
      result.type = this.type;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }
  }
}
