package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String shippingKey;

  private String name;

  private JsonNode value;

  public SetStagedOrderShippingCustomFieldOutput() {
  }

  public SetStagedOrderShippingCustomFieldOutput(String type, String shippingKey, String name,
      JsonNode value) {
    this.type = type;
    this.shippingKey = shippingKey;
    this.name = name;
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingCustomFieldOutput{type='" + type + "', shippingKey='" + shippingKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingCustomFieldOutput that = (SetStagedOrderShippingCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shippingKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String shippingKey;

    private String name;

    private JsonNode value;

    public SetStagedOrderShippingCustomFieldOutput build() {
      SetStagedOrderShippingCustomFieldOutput result = new SetStagedOrderShippingCustomFieldOutput();
      result.type = this.type;
      result.shippingKey = this.shippingKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }
  }
}
