package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderShippingMethodTaxAmount {
  private ExternalTaxAmountDraft externalTaxAmount;

  private String shippingKey;

  public SetStagedOrderShippingMethodTaxAmount() {
  }

  public SetStagedOrderShippingMethodTaxAmount(ExternalTaxAmountDraft externalTaxAmount,
      String shippingKey) {
    this.externalTaxAmount = externalTaxAmount;
    this.shippingKey = shippingKey;
  }

  public ExternalTaxAmountDraft getExternalTaxAmount() {
    return externalTaxAmount;
  }

  public void setExternalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
    this.externalTaxAmount = externalTaxAmount;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingMethodTaxAmount{externalTaxAmount='" + externalTaxAmount + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingMethodTaxAmount that = (SetStagedOrderShippingMethodTaxAmount) o;
    return Objects.equals(externalTaxAmount, that.externalTaxAmount) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalTaxAmount, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ExternalTaxAmountDraft externalTaxAmount;

    private String shippingKey;

    public SetStagedOrderShippingMethodTaxAmount build() {
      SetStagedOrderShippingMethodTaxAmount result = new SetStagedOrderShippingMethodTaxAmount();
      result.externalTaxAmount = this.externalTaxAmount;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder externalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
      this.externalTaxAmount = externalTaxAmount;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
