package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingRateInputOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ShippingRateInputDraftOutput shippingRateInput;

  public SetStagedOrderShippingRateInputOutput() {
  }

  public SetStagedOrderShippingRateInputOutput(String type,
      ShippingRateInputDraftOutput shippingRateInput) {
    this.type = type;
    this.shippingRateInput = shippingRateInput;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ShippingRateInputDraftOutput getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraftOutput shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingRateInputOutput{type='" + type + "', shippingRateInput='" + shippingRateInput + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingRateInputOutput that = (SetStagedOrderShippingRateInputOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shippingRateInput, that.shippingRateInput);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shippingRateInput);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ShippingRateInputDraftOutput shippingRateInput;

    public SetStagedOrderShippingRateInputOutput build() {
      SetStagedOrderShippingRateInputOutput result = new SetStagedOrderShippingRateInputOutput();
      result.type = this.type;
      result.shippingRateInput = this.shippingRateInput;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraftOutput shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }
  }
}
