package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedQuoteSellerComment {
  private String sellerComment;

  public SetStagedQuoteSellerComment() {
  }

  public SetStagedQuoteSellerComment(String sellerComment) {
    this.sellerComment = sellerComment;
  }

  public String getSellerComment() {
    return sellerComment;
  }

  public void setSellerComment(String sellerComment) {
    this.sellerComment = sellerComment;
  }

  @Override
  public String toString() {
    return "SetStagedQuoteSellerComment{sellerComment='" + sellerComment + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedQuoteSellerComment that = (SetStagedQuoteSellerComment) o;
    return Objects.equals(sellerComment, that.sellerComment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerComment);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sellerComment;

    public SetStagedQuoteSellerComment build() {
      SetStagedQuoteSellerComment result = new SetStagedQuoteSellerComment();
      result.sellerComment = this.sellerComment;
      return result;
    }

    public Builder sellerComment(String sellerComment) {
      this.sellerComment = sellerComment;
      return this;
    }
  }
}
