package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStandalonePriceDiscountedPrice {
  private DiscountedProductPriceValueInput discounted;

  public SetStandalonePriceDiscountedPrice() {
  }

  public SetStandalonePriceDiscountedPrice(DiscountedProductPriceValueInput discounted) {
    this.discounted = discounted;
  }

  public DiscountedProductPriceValueInput getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValueInput discounted) {
    this.discounted = discounted;
  }

  @Override
  public String toString() {
    return "SetStandalonePriceDiscountedPrice{discounted='" + discounted + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStandalonePriceDiscountedPrice that = (SetStandalonePriceDiscountedPrice) o;
    return Objects.equals(discounted, that.discounted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discounted);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DiscountedProductPriceValueInput discounted;

    public SetStandalonePriceDiscountedPrice build() {
      SetStandalonePriceDiscountedPrice result = new SetStandalonePriceDiscountedPrice();
      result.discounted = this.discounted;
      return result;
    }

    public Builder discounted(DiscountedProductPriceValueInput discounted) {
      this.discounted = discounted;
      return this;
    }
  }
}
