package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStateTransitions {
  private List<ResourceIdentifierInput> transitions;

  public SetStateTransitions() {
  }

  public SetStateTransitions(List<ResourceIdentifierInput> transitions) {
    this.transitions = transitions;
  }

  public List<ResourceIdentifierInput> getTransitions() {
    return transitions;
  }

  public void setTransitions(List<ResourceIdentifierInput> transitions) {
    this.transitions = transitions;
  }

  @Override
  public String toString() {
    return "SetStateTransitions{transitions='" + transitions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStateTransitions that = (SetStateTransitions) o;
    return Objects.equals(transitions, that.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transitions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> transitions;

    public SetStateTransitions build() {
      SetStateTransitions result = new SetStateTransitions();
      result.transitions = this.transitions;
      return result;
    }

    public Builder transitions(List<ResourceIdentifierInput> transitions) {
      this.transitions = transitions;
      return this;
    }
  }
}
