package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStoreCountries {
  private List<StoreCountryInput> countries;

  public SetStoreCountries() {
  }

  public SetStoreCountries(List<StoreCountryInput> countries) {
    this.countries = countries;
  }

  public List<StoreCountryInput> getCountries() {
    return countries;
  }

  public void setCountries(List<StoreCountryInput> countries) {
    this.countries = countries;
  }

  @Override
  public String toString() {
    return "SetStoreCountries{countries='" + countries + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStoreCountries that = (SetStoreCountries) o;
    return Objects.equals(countries, that.countries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countries);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<StoreCountryInput> countries;

    public SetStoreCountries build() {
      SetStoreCountries result = new SetStoreCountries();
      result.countries = this.countries;
      return result;
    }

    public Builder countries(List<StoreCountryInput> countries) {
      this.countries = countries;
      return this;
    }
  }
}
