package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStoreDistributionChannels {
  private List<ResourceIdentifierInput> distributionChannels;

  public SetStoreDistributionChannels() {
  }

  public SetStoreDistributionChannels(List<ResourceIdentifierInput> distributionChannels) {
    this.distributionChannels = distributionChannels;
  }

  public List<ResourceIdentifierInput> getDistributionChannels() {
    return distributionChannels;
  }

  public void setDistributionChannels(List<ResourceIdentifierInput> distributionChannels) {
    this.distributionChannels = distributionChannels;
  }

  @Override
  public String toString() {
    return "SetStoreDistributionChannels{distributionChannels='" + distributionChannels + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStoreDistributionChannels that = (SetStoreDistributionChannels) o;
    return Objects.equals(distributionChannels, that.distributionChannels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(distributionChannels);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> distributionChannels;

    public SetStoreDistributionChannels build() {
      SetStoreDistributionChannels result = new SetStoreDistributionChannels();
      result.distributionChannels = this.distributionChannels;
      return result;
    }

    public Builder distributionChannels(List<ResourceIdentifierInput> distributionChannels) {
      this.distributionChannels = distributionChannels;
      return this;
    }
  }
}
